package cn.com.duiba.kjy.base.customweb.web.bean;

import org.apache.commons.lang3.StringUtils;

import java.util.HashMap;
import java.util.Map;

/**
 * @author dugq
 * @date 2021/3/23 7:55 下午
 */
public enum RequestTypeEnum {

    GET("get"),
    POST("post"),
    HEAD("HEAD"),
    OPTIONS("OPTIONS"),
    PUT("PUT"),
    DELETE("DELETE"),
    TRACE("TRACE"),
    ALL("ALL")
    ;

    private String type;

    private static final Map<String,RequestTypeEnum> all = new HashMap<>();

    RequestTypeEnum(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }

    public RequestTypeEnum getByType(String type){
        if (StringUtils.isBlank(type)){
            return null;
        }
        return all.get(type);
    }


}
