/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.filter;

import cn.com.duiba.boot.utils.NetUtils;
import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.kjy.base.customweb.util.ServiceGroupUtils;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.filter.CustomFilter;
import cn.com.duiba.kjy.base.customweb.web.filter.CustomFilterChain;
import cn.com.duibaboot.ext.autoconfigure.cloud.netflix.feign.DuibaFeignProperties;
import cn.com.duibaboot.ext.autoconfigure.grouping.RocketMqMessageListenerPostProcessor4Group;
import cn.com.duibaboot.ext.autoconfigure.grouping.ServiceGroupContext;
import java.io.IOException;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;

public class ServiceGroupFilter
implements CustomFilter {
    public static final String ROCKETMQ_MSG_DISPATCH_PATH = "/bootext/serviceGroup/rocketmqMsgDispatch";
    @Resource
    private ApplicationContext applicationContext;

    private void handleRocketMQMessage(KjjHttpRequest req, KjjHttpResponse resp) throws IOException {
        byte[] bs = req.getRequestBody();
        RocketMqMessageListenerPostProcessor4Group.RocketMqRunInOtherNodeTask task = (RocketMqMessageListenerPostProcessor4Group.RocketMqRunInOtherNodeTask)DuibaFeignProperties.DuibaFeignSerialization.HESSIAN2.deserialize(bs);
        task.setApplicationContext(this.applicationContext);
        Object obj = task.call();
        byte[] returnBs = DuibaFeignProperties.DuibaFeignSerialization.HESSIAN2.serialize(obj);
        resp.getContent().writeBytes(returnBs);
        resp.flushAndClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(CustomFilterChain chain, KjjHttpRequest request, KjjHttpResponse response) throws Throwable {
        String uri;
        String groupKey = ServiceGroupUtils.getDuibaServiceGroupKey(request);
        if (groupKey == null && SpringEnvironmentUtils.isDevEnv()) {
            String ip = request.getIpAddr();
            if (ip.equals("127.0.0.1")) {
                ip = NetUtils.getLocalIp();
            }
            groupKey = "dev_ip_" + ip;
        }
        if (StringUtils.isNotBlank((CharSequence)groupKey)) {
            ServiceGroupContext.setGroupKey((String)groupKey);
        }
        if (ROCKETMQ_MSG_DISPATCH_PATH.equals(uri = request.getRequestURI())) {
            this.handleRocketMQMessage(request, response);
            return;
        }
        try {
            chain.filter(request, response);
        }
        finally {
            ServiceGroupContext.removeGroupKey();
        }
    }
}

