/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.enums;

import cn.com.duiba.kjy.base.api.utils.IdMakeUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ProviderChannelEnum {
    WECHAT_OA(1, "/oax", "\u4e2a\u5fae\u516c\u4f17\u53f7"),
    WX_WORK(2, "/qywx", "\u4f01\u5fae\u5e94\u7528"),
    THIRD_PARTY_APP(3, "/app", "\u7b2c\u4e09\u65b9APP");

    private static final Logger log;
    private final Integer code;
    private final String urlPrefix;
    private final String desc;
    private static final Map<Integer, ProviderChannelEnum> ENUM_MAP;

    private ProviderChannelEnum(Integer code, String urlPrefix, String desc) {
        this.code = code;
        this.urlPrefix = urlPrefix;
        this.desc = desc;
    }

    public static ProviderChannelEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ENUM_MAP.get(code);
    }

    public String getUrl(String channelId, String subUrl) {
        if (StringUtils.isBlank((String)channelId)) {
            return subUrl;
        }
        return this.urlPrefix + channelId + subUrl;
    }

    public String getUrl(Long channelId, String subUrl) {
        if (Objects.isNull(channelId)) {
            return subUrl;
        }
        return this.urlPrefix + "/" + IdMakeUtil.encodingId(channelId) + subUrl;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        log = LoggerFactory.getLogger(ProviderChannelEnum.class);
        ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(ProviderChannelEnum.values()).collect(Collectors.toMap(ProviderChannelEnum::getCode, Function.identity(), (v1, v2) -> {
            log.error("ProviderChannelEnum, type distinct, type={}", (Object)v2.getCode());
            return v2;
        })));
    }
}

