/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.condition;

import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.condition.AbstractRequestCondition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

public class PatternsRequestCondition
extends AbstractRequestCondition<PatternsRequestCondition> {
    private final Set<String> patterns;
    private final PathMatcher pathMatcher;
    private final boolean useTrailingSlashMatch = true;

    public PatternsRequestCondition(String ... patterns) {
        this(Arrays.asList(patterns), null);
    }

    public PatternsRequestCondition(String[] patterns, @Nullable PathMatcher pathMatcher) {
        this(Arrays.asList(patterns), pathMatcher);
    }

    private PatternsRequestCondition(Collection<String> patterns, @Nullable PathMatcher pathMatcher) {
        this.patterns = Collections.unmodifiableSet(PatternsRequestCondition.prependLeadingSlash(patterns));
        this.pathMatcher = pathMatcher != null ? pathMatcher : new AntPathMatcher();
    }

    private PatternsRequestCondition(Set<String> patterns, PatternsRequestCondition other) {
        this.patterns = patterns;
        this.pathMatcher = other.pathMatcher;
    }

    /*
     * WARNING - void declaration
     */
    private static Set<String> prependLeadingSlash(Collection<String> patterns) {
        if (patterns.isEmpty()) {
            return Collections.singleton("");
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>(patterns.size());
        for (String string : patterns) {
            void var3_3;
            if (StringUtils.hasLength((String)string) && !string.startsWith("/")) {
                String string2 = "/" + string;
            }
            result.add((String)var3_3);
        }
        return result;
    }

    public Set<String> getPatterns() {
        return this.patterns;
    }

    @Override
    protected Collection<String> getContent() {
        return this.patterns;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    @Override
    public PatternsRequestCondition combine(PatternsRequestCondition other) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (!this.patterns.isEmpty() && !other.patterns.isEmpty()) {
            for (String pattern1 : this.patterns) {
                for (String pattern2 : other.patterns) {
                    result.add(this.pathMatcher.combine(pattern1, pattern2));
                }
            }
        } else if (!this.patterns.isEmpty()) {
            result.addAll(this.patterns);
        } else if (!other.patterns.isEmpty()) {
            result.addAll(other.patterns);
        } else {
            result.add("");
        }
        return new PatternsRequestCondition(result, this);
    }

    @Override
    @Nullable
    public boolean getMatchingCondition(KjjHttpRequest request) {
        if (this.patterns.isEmpty()) {
            return false;
        }
        String lookupPath = request.getRequestURI();
        List<String> matches = this.getMatchingPatterns(lookupPath);
        return CollectionUtils.isNotEmpty(matches);
    }

    public List<String> getMatchingPatterns(String lookupPath) {
        List matches = null;
        for (String pattern : this.patterns) {
            String match = this.getMatchingPattern(pattern, lookupPath);
            if (match == null) continue;
            matches = matches != null ? matches : new ArrayList();
            matches.add(match);
        }
        if (matches == null) {
            return Collections.emptyList();
        }
        if (matches.size() > 1) {
            matches.sort(this.pathMatcher.getPatternComparator(lookupPath));
        }
        return matches;
    }

    @Nullable
    private String getMatchingPattern(String pattern, String lookupPath) {
        if (pattern.equals(lookupPath)) {
            return pattern;
        }
        if (this.pathMatcher.match(pattern, lookupPath)) {
            return pattern;
        }
        Objects.requireNonNull(this);
        if (!pattern.endsWith("/") && this.pathMatcher.match(pattern + "/", lookupPath)) {
            return pattern + "/";
        }
        return null;
    }

    @Override
    public int compareTo(PatternsRequestCondition other, KjjHttpRequest request) {
        String lookupPath = request.getRequestURI();
        Comparator patternComparator = this.pathMatcher.getPatternComparator(lookupPath);
        Iterator<String> iterator = this.patterns.iterator();
        Iterator<String> iteratorOther = other.patterns.iterator();
        while (iterator.hasNext() && iteratorOther.hasNext()) {
            int result = patternComparator.compare(iterator.next(), iteratorOther.next());
            if (result == 0) continue;
            return result;
        }
        if (iterator.hasNext()) {
            return -1;
        }
        if (iteratorOther.hasNext()) {
            return 1;
        }
        return 0;
    }
}

