/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.request.iddecode;

import cn.com.duiba.kjy.base.api.enums.IdDecode;
import cn.com.duiba.kjy.base.api.request.iddecode.IdDecodeBean;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.ConversionNotSupportedException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.Order;
import org.springframework.validation.BindException;
import org.springframework.validation.Errors;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.annotation.MethodArgumentConversionNotSupportedException;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

@Order(value=-2147483648)
public class IdArgumentResolver
extends IdDecodeBean
implements HandlerMethodArgumentResolver {
    private static final Logger log = LoggerFactory.getLogger(IdArgumentResolver.class);

    public boolean supportsParameter(MethodParameter parameter) {
        return (parameter.hasParameterAnnotation(IdDecode.class) || parameter.getParameterType().isAnnotationPresent(IdDecode.class)) && !parameter.getParameterType().isAnnotationPresent(RequestBody.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        return this.resolverParameterInRequestUrl(parameter, webRequest, binderFactory);
    }

    private Object resolverParameterInRequestUrl(MethodParameter parameter, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        Class parameterType = parameter.getParameterType();
        if (this.isPrimitiveOrString(parameterType)) {
            return this.resolverPrimitiveAndStringValue(parameter, webRequest);
        }
        if (this.isArray(parameterType).booleanValue() || this.isCollection(parameterType).booleanValue()) {
            String parameterName = parameter.getParameterName();
            String[] parameterValues = webRequest.getParameterValues(parameterName);
            if (Objects.isNull(parameterValues)) {
                return null;
            }
            IdDecode parameterAnnotation = (IdDecode)parameter.getParameterAnnotation(IdDecode.class);
            List<Long> ids = Arrays.stream(parameterValues).map(value -> this.decodeId((String)value, Long.class, parameterName)).collect(Collectors.toList());
            if (this.isArray(parameterType).booleanValue()) {
                return ids.toArray(new Long[0]);
            }
            if (Set.class.isAssignableFrom(parameterType)) {
                return new HashSet(ids);
            }
            return ids;
        }
        List<Field> declaredFields = this.getAllFields(parameterType);
        Object instance = parameterType.newInstance();
        for (Field field : declaredFields) {
            String fieldValue = webRequest.getParameter(field.getName());
            if (!Objects.nonNull(fieldValue)) continue;
            this.resolverObjectFiled(parameter, webRequest, binderFactory, instance, field);
        }
        this.validatorIfNecessary(parameter, webRequest, binderFactory, instance);
        return instance;
    }

    private void validatorIfNecessary(MethodParameter parameter, NativeWebRequest webRequest, WebDataBinderFactory binderFactory, Object instance) throws Exception {
        WebDataBinder binder = binderFactory.createBinder(webRequest, instance, parameter.getParameterName());
        if (binder.getTarget() != null) {
            this.validateIfApplicable(binder, parameter);
            if (binder.getBindingResult().hasErrors() && this.isBindExceptionRequired(parameter)) {
                throw new BindException(binder.getBindingResult());
            }
        }
    }

    private void resolverObjectFiled(MethodParameter parameter, NativeWebRequest webRequest, WebDataBinderFactory binderFactory, Object instance, Field field) throws Exception {
        IdDecode annotation = field.getAnnotation(IdDecode.class);
        if (this.isPrimitiveOrString(field.getType()) && Objects.nonNull(annotation)) {
            String fieldValue = webRequest.getParameter(field.getName());
            Long id = this.decodeId(fieldValue, parameter.getParameterType(), field.getName());
            WebDataBinder binder = binderFactory.createBinder(webRequest, null, field.getName());
            Object valueObj = binder.convertIfNecessary((Object)id, field.getType(), field);
            field.setAccessible(true);
            field.set(instance, valueObj);
        } else {
            Object fieldValue = webRequest.getParameter(field.getName());
            field.setAccessible(true);
            if (binderFactory != null) {
                WebDataBinder binder = binderFactory.createBinder(webRequest, null, field.getName());
                try {
                    fieldValue = binder.convertIfNecessary(fieldValue, field.getType(), field);
                    field.set(instance, fieldValue);
                }
                catch (ConversionNotSupportedException ex) {
                    throw new MethodArgumentConversionNotSupportedException(fieldValue, ex.getRequiredType(), field.getName(), parameter, ex.getCause());
                }
                catch (TypeMismatchException ex) {
                    throw new MethodArgumentTypeMismatchException(fieldValue, ex.getRequiredType(), field.getName(), parameter, ex.getCause());
                }
            } else {
                log.error("binderFactory is null ");
            }
        }
    }

    private Object resolverPrimitiveAndStringValue(MethodParameter parameter, NativeWebRequest webRequest) {
        String parameterName = parameter.getParameterName();
        String value = webRequest.getParameter(parameterName);
        return this.decodeId(value, parameter.getParameterType(), parameterName);
    }

    private boolean isBindExceptionRequired(MethodParameter parameter) {
        int i = parameter.getParameterIndex();
        Class<?>[] paramTypes = parameter.getMethod().getParameterTypes();
        boolean hasBindingResult = paramTypes.length > i + 1 && Errors.class.isAssignableFrom(paramTypes[i + 1]);
        return !hasBindingResult;
    }

    private void validateIfApplicable(WebDataBinder binder, MethodParameter parameter) {
        Annotation[] annotations;
        for (Annotation ann : annotations = parameter.getParameterAnnotations()) {
            Object[] objectArray;
            Object hints;
            Validated validatedAnn = (Validated)AnnotationUtils.getAnnotation((Annotation)ann, Validated.class);
            if (validatedAnn == null && !ann.annotationType().getSimpleName().startsWith("Valid")) continue;
            Object object = hints = validatedAnn != null ? validatedAnn.value() : AnnotationUtils.getValue((Annotation)ann);
            if (hints instanceof Object[]) {
                objectArray = hints;
            } else {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = hints;
            }
            Object[] validationHints = objectArray;
            binder.validate(validationHints);
            break;
        }
    }
}

