package cn.com.duiba.kjy.base.api.request.iddecode;

import cn.com.duiba.kjy.base.api.utils.IdMakeUtil;
import cn.com.duiba.kjy.base.exception.KjjBaseException;
import cn.com.duiba.kjy.base.exception.errorcode.BaseErrorCode;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

/**
 * Created by dugq on 2019-10-24.
 */
@Slf4j
public class IdDecodeBean{

    protected Long decodeId(String value, Class<?> parameterType, String filedName) {
        if(StringUtils.isBlank(value)){
            return null;
        }
        Long id = IdMakeUtil.decodingId(value);
        if(Objects.isNull(id) && (StringUtils.isNotBlank(value) || parameterType.isPrimitive())){
            HttpServletRequest request = getRequest();
            log.warn("id ILLEGAL; url = {} \n Referer = {} \n X-Transaction-ID = {} \n 非法参数： {} = {} \n ",
                    request.getRequestURI(),request.getHeader("Referer"),request.getHeader("X-Transaction-ID"),filedName,value);
            throw new KjjBaseException(BaseErrorCode.ID_ERROR);
        }
        if(Objects.nonNull(id) && StringUtils.equals(value,id.toString())){
            try {
                HttpServletRequest request = getRequest();
                log.info("id maker has not use encoding; url = {} \n Referer = {} \n hash-path = {}  \n {} = {}  \n \n please deal this url quickly!",
                            request.getRequestURI(),request.getHeader("Referer"),request.getHeader("W-Hash-Path"),filedName,value);
            }catch (Exception e){
               log.error("记录日志错误",e);
            }
        }
        return id;
    }

    private HttpServletRequest getRequest(){
        return ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
    }


    protected boolean isPrimitiveOrString(Class<?> parameterType) {
        return parameterType.isPrimitive() || Number.class.isAssignableFrom(parameterType) || parameterType.equals(String.class);
    }
    protected Boolean isArray(Class<?> parameterType) {
        return parameterType.isArray();
    }
    protected Boolean isCollection(Class<?> parameterType) {
        return List.class.isAssignableFrom(parameterType) || Set.class.isAssignableFrom(parameterType);
    }

    protected List<Field> getAllFields(Class clazz) {
        if(Objects.isNull(clazz) || clazz.isInterface()){
            return Collections.emptyList();
        }
        List<Field> fieldList = new ArrayList<>();
        while (clazz != Object.class) {
            fieldList.addAll(new ArrayList<>(Arrays.asList(clazz.getDeclaredFields())));
            clazz = clazz.getSuperclass();
        }
        return fieldList;

    }

    protected Boolean isMap(Class<?> parameterType) {
        return Map.class.isAssignableFrom(parameterType);
    }
}
