/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.handler.mapping;

import cn.com.duiba.kjy.base.customweb.util.StopWatchUtil;
import cn.com.duiba.kjy.base.customweb.web.adaptor.RequestHandlerMappingAdaptor;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.handler.mapping.RequestMappingsRegister;
import cn.com.duiba.kjy.base.customweb.web.interceptor.KjjInterceptor;
import java.util.List;
import org.springframework.util.StopWatch;

public class HandlerExecutionChain {
    private final List<KjjInterceptor> interceptors;
    private final RequestMappingsRegister requestMappingsRegister;
    private final Object handler;

    public HandlerExecutionChain(List<KjjInterceptor> kjjInterceptors, RequestMappingsRegister requestMappingsRegister, Object handler) {
        this.requestMappingsRegister = requestMappingsRegister;
        this.interceptors = kjjInterceptors;
        this.handler = handler;
    }

    public boolean applyPreHandle(KjjHttpRequest fullHttpRequest, KjjHttpResponse response, Object controllerMappingHandler) {
        StopWatch interceptor = StopWatchUtil.getAndStart();
        for (KjjInterceptor kjjInterceptor : this.interceptors) {
            if (kjjInterceptor.applyPreHandle(fullHttpRequest, response, controllerMappingHandler)) continue;
            return true;
        }
        StopWatchUtil.stop(StopWatchUtil.Key.INTERCEPTOR_BEFORE, fullHttpRequest, interceptor);
        return false;
    }

    public void applyPostHandle(KjjHttpRequest request, KjjHttpResponse response, Object handler, Object result) {
        StopWatch interceptor = StopWatchUtil.getAndStart();
        for (KjjInterceptor kjjInterceptor : this.interceptors) {
            kjjInterceptor.applyPostHandle(request, response, handler, result);
        }
        StopWatchUtil.stop(StopWatchUtil.Key.INTERCEPTOR_AFTER, request, interceptor);
    }

    public void afterCompletion(KjjHttpRequest request, KjjHttpResponse response, Exception e) {
        for (KjjInterceptor kjjInterceptor : this.interceptors) {
            kjjInterceptor.afterCompletion(request, response, this.handler, e);
        }
    }

    public RequestHandlerMappingAdaptor getAdaptor() {
        return this.requestMappingsRegister.getAdaptor();
    }

    public List<KjjInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public RequestMappingsRegister getRequestMappingsRegister() {
        return this.requestMappingsRegister;
    }

    public Object getHandler() {
        return this.handler;
    }
}

