package cn.com.duiba.kjy.base.customweb.web.codec.jackson;

import cn.com.duiba.kjy.base.api.utils.IdMakeUtil;
import cn.com.duiba.kjy.base.customweb.exception.IllegalIdException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonTokenId;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.commons.lang.StringUtils;

import java.io.IOException;
import java.util.Objects;

/**
 * @author dugq
 * @date 2021/3/28 1:24 下午
 */
public class JacksonIdDeserialization extends JsonDeserializer {

    @Override
    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (Objects.equals(p.getCurrentTokenId(),JsonTokenId.ID_STRING)){
            try {
                final String valueAsString = p.getValueAsString();
                if (StringUtils.isBlank(valueAsString)){
                    return null;
                }
                final Long id = IdMakeUtil.decodingId(valueAsString);
                if (Objects.isNull(id) && StringUtils.isNotBlank(valueAsString)){
                    throw new IllegalIdException();
                }
                return id;
            }catch (Exception e){
                throw new IllegalIdException();
            }
        }
        throw new IllegalIdException();
    }
}
