package cn.com.duiba.kjy.base.customweb.web.filter;

import cn.com.duiba.kjy.base.customweb.sever.NettyConstant;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import cn.com.duiba.kjy.base.customweb.web.bean.RequestTypeEnum;
import io.netty.handler.codec.http.HttpHeaderNames;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * @author dugq
 * @date 2022/2/28 5:33 下午
 */
@Slf4j
public class CrossDomainResponseFilter implements CustomFilter{

    private final List<String> domains;
    private final String allowHeads;

    public CrossDomainResponseFilter(String domains,String headers) {
        //创建一个不可修改的domains
        if (StringUtils.isBlank(domains)){
            this.domains = Collections.emptyList();
        }else{
            this.domains = Arrays.asList(domains.split(NettyConstant.DEFAULT_SEPARATION));
        }
        if (StringUtils.isBlank(headers)){
            headers = "Content-Type, x-requested-with, Origin, X-Requested-With, Content-Type, Accept, Cookie";
        }
        this.allowHeads = headers;
    }

    @Override
    public void doFilter(CustomFilterChain customFilterChain, KjjHttpRequest httpRequest, KjjHttpResponse response) throws Throwable {
        URI uri = getOriginRequestUri(httpRequest);
        try {
            //如果是option 请求，直接进行处理
            if (StringUtils.equalsIgnoreCase(httpRequest.getMethod(), RequestTypeEnum.OPTIONS.getType())){
                dealOptionRequest(uri,response);
                response.flushAndClose();
                return;
            }
        }catch (Exception e){
            log.info("deal cross domain option request has exception : ",e);
        }
        customFilterChain.filter(httpRequest, response);
        try {
            if (StringUtils.isBlank(uri.getHost()) || StringUtils.equalsIgnoreCase(uri.getHost(),httpRequest.getUri().getHost())){
                dealOptionRequest(uri,response);
            }
        }catch (Exception e){
            log.info("deal cross domain has exception : ",e);
        }
    }

    private void dealOptionRequest(URI uri, KjjHttpResponse response) {
        final String host = uri.getHost();
        if (isAllowDomain(host)){
            final int port = uri.getPort();
            if (port==-1 || port==80){
                response.addHeader(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN,uri.getScheme()+"://"+host);
            }else{
                response.addHeader(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN,uri.getScheme()+"://"+host+":"+port);
            }
            response.addHeader(HttpHeaderNames.ACCESS_CONTROL_ALLOW_METHODS, "POST, GET, OPTIONS");
            response.addHeader(HttpHeaderNames.ACCESS_CONTROL_MAX_AGE, "3600");
            response.addHeader(HttpHeaderNames.ACCESS_CONTROL_ALLOW_HEADERS, allowHeads);
            response.addHeader(HttpHeaderNames.ACCESS_CONTROL_ALLOW_CREDENTIALS, "true");
        }
    }

    @NotNull
    private URI getOriginRequestUri(KjjHttpRequest httpRequest) {
        String origin = httpRequest.getHeader(HttpHeaderNames.ORIGIN.toString());
        log.info("来啦，来啦 uri={}", httpRequest.getRequestURI());
        if (StringUtils.isBlank(origin)){
            origin = httpRequest.getHeader(HttpHeaderNames.REFERER.toString());
        }
        return URI.create(origin);
    }

    private boolean isAllowDomain(String host){
        if (domains.contains(host)){
            return true;
        }
        if (host.contains(".")){
            final String subHost = host.substring(host.indexOf(".") + 1);
            return isAllowDomain(subHost);
        }
        return false;
    }


}
