package cn.com.duiba.kjy.base.customweb.web.handler.exception;

import cn.com.duiba.kjy.base.customweb.exception.ResponseStatusException;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpResponse;
import org.apache.http.entity.ContentType;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;

/**
 * @author dugq
 * @date 2021/3/30 4:33 下午
 */
@Order(Ordered.HIGHEST_PRECEDENCE+10)
public class ResponseStatusExceptionHandler implements ExceptionHandler{
    @Override
    public boolean doHandler(KjjHttpRequest e, KjjHttpResponse response, Throwable ex) {
        if (ex instanceof ResponseStatusException){
            final ResponseStatusException responseStatusException = (ResponseStatusException) ex;
            response.setContentType(ContentType.TEXT_PLAIN.getMimeType());
            response.setStatus(responseStatusException.getHttpResponseStatus());
            response.write(responseStatusException.getHttpResponseStatus().reasonPhrase());
            response.flushAndClose();
            return true;
        }
        return false;
    }
}
