package cn.com.duibaboot.kjj.oss.conf;

import cn.com.duibaboot.ext.autoconfigure.threadpool.properties.ThreadPoolProperties;
import cn.com.duibaboot.ext.autoconfigure.threadpool.wrapper.ThreadPoolExecutorWrapper;
import com.aliyun.oss.OSSClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * @author dugq
 * @date 2021/7/21 2:22 下午
 */
@Configuration
@ConditionalOnClass(OSSClient.class)
public class OssAutoConfiguration {

    @Bean
    public ThreadPoolExecutorWrapper ossExecutorService(){
        ThreadPoolProperties properties = new ThreadPoolProperties();
        properties.setQueueSize(10000);
        properties.setCoreSize(10);
        properties.setMaxSize(10);
        return new ThreadPoolExecutorWrapper("oss-upload-threadPool", properties);
    }

    @Bean
    public static OssBeanDefinitionRegistryPostProcessor ossBeanDefinitionRegistryPostProcessor(){
        return new OssBeanDefinitionRegistryPostProcessor();
    }


}
