package cn.com.duiba.kjy.base.api.utils.login;

import cn.com.duiba.kjy.base.api.bean.login.LoginConstant;
import cn.com.duiba.kjy.base.api.bean.login.TkuBean;
import cn.com.duiba.kjy.base.api.constant.DefaultConstant;
import cn.com.duiba.kjy.base.api.enums.login.UserSourceEnum;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Objects;

/**
 * 客集集业务专用的获取当前请求中用户信息的工具类
 * @author dugq
 * @date 2021/12/22 11:35 上午
 */
public class KjjRequestTool extends BaseRequestTool{

    private KjjRequestTool(){}

    public static void initHttp(HttpServletRequest request, HttpServletResponse response){
        BaseRequestTool.initHttp(request,response,UserSourceEnum.KJJ_ACCOUNT);
    }

    public static boolean isSnapshotModel(){
        String modelValue = RequestTool.getCookie(getRequest(), DefaultConstant.KJY_SNAPSHOT_MODEL_KEY);
        if (StringUtils.isBlank(modelValue)){
            modelValue = getRequest().getHeader(DefaultConstant.KJY_SNAPSHOT_MODEL_KEY);
        }
        return Objects.equals(modelValue,DefaultConstant.KJY_SNAPSHOT_MODEL_VAL);
    }

    public static Long getUserId(){
        TkuBean userInfo = BaseRequestTool.getUserInfo(UserSourceEnum.KJJ_ACCOUNT);
        if (Objects.isNull(userInfo)){
            return null;
        }
        return userInfo.getUid();
    }

    public static Boolean isLogin(){
        return BaseRequestTool.isLogin(UserSourceEnum.KJJ_ACCOUNT);
    }

    public static Boolean isNotLogin(){
        return !BaseRequestTool.isLogin(UserSourceEnum.KJJ_ACCOUNT);
    }

    public static String getPhone(){
        TkuBean userInfo = BaseRequestTool.getUserInfo(UserSourceEnum.KJJ_ACCOUNT);
        if (Objects.isNull(userInfo)){
            return null;
        }
        return userInfo.getPhone();
    }

    /**
     * @return  {@link cn.com.duiba.user.service.api.enums.user.PlatformTypeEnum}
     */
    public static Integer getUserType(){
        TkuBean userInfo = BaseRequestTool.getUserInfo(UserSourceEnum.KJJ_ACCOUNT);
        if (Objects.isNull(userInfo)){
            return null;
        }
        return userInfo.getUidType();
    }

    /**
     * @return  当前用户登陆时的渠道ID
     */
    public static Long getChannel(){
        TkuBean userInfo = BaseRequestTool.getUserInfo(UserSourceEnum.KJJ_ACCOUNT);
        if (Objects.isNull(userInfo)){
            return null;
        }
        return userInfo.getChannelId();
    }

    /**
     * 注意：此方法是从request header中读取当前请求所在页面的渠道
     *  和{@link #getChannel}是不一样的
     */
    public static String getRequestChannel(){
        return getRequest().getHeader(LoginConstant.USING_CHANNEL_PARAM_NAME);
    }

    public static TkuBean getUserInfo(){
        return BaseRequestTool.getUserInfo(UserSourceEnum.KJJ_ACCOUNT);
    }

    /**
     * 这里返回的时候登陆时候的sellerId，为空时并不能说明用户就不是代理人。
     * 建议在为null的时候，根据uid再去查询确认一次
     */
    public static Long getSellerId(){
        TkuBean userInfo = BaseRequestTool.getUserInfo(UserSourceEnum.KJJ_ACCOUNT);
        if (Objects.isNull(userInfo)){
            return null;
        }
        return userInfo.getSid();
    }


}
