/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.response;

import cn.com.duiba.kjy.base.api.request.Result;
import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseUtils {
    private static final Logger log = LoggerFactory.getLogger(ResponseUtils.class);

    private ResponseUtils() {
    }

    public static <T> void out(HttpServletResponse response, Result<T> result) {
        response.setContentType("application/json;charset=UTF-8");
        try {
            ResponseUtils.doResponse(response, JSON.toJSONString(result));
        }
        catch (IOException e) {
            log.warn("response close");
        }
    }

    public static void out(HttpServletResponse response, String content) throws IOException {
        response.setContentType("text/html; charset=utf-8");
        ResponseUtils.doResponse(response, content);
    }

    private static void doResponse(HttpServletResponse response, String content) throws IOException {
        response.setStatus(200);
        PrintWriter out = response.getWriter();
        out.print(content);
        out.flush();
        out.close();
    }
}

