/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.utils;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import javax.annotation.Nonnull;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KjyEncryptUtil {
    private static final Logger log = LoggerFactory.getLogger(KjyEncryptUtil.class);
    private static final String AES_CIPHER_NAME = "AES/CBC/PKCS7Padding";
    private static final String AES_KEY_SPEC_NAME = "AES";

    private KjyEncryptUtil() {
    }

    public static String encodeByAesBase64(String data, String key) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{data, key})) {
            return null;
        }
        String iv = StringUtils.substring((String)DigestUtils.md5Hex((String)key), (int)0, (int)16);
        byte[] bytes = KjyEncryptUtil.encodeByAes(data.getBytes(StandardCharsets.UTF_8), key.getBytes(StandardCharsets.UTF_8), iv.getBytes(StandardCharsets.UTF_8));
        return Base64.encodeBase64String((byte[])bytes);
    }

    public static String decodeByBase64Aes(String data, String key) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{data, key})) {
            return null;
        }
        String iv = StringUtils.substring((String)DigestUtils.md5Hex((String)key), (int)0, (int)16);
        byte[] dataBytes = Base64.decodeBase64((String)data);
        byte[] bytes = KjyEncryptUtil.decodeByAes(dataBytes, key.getBytes(StandardCharsets.UTF_8), iv.getBytes(StandardCharsets.UTF_8));
        return new String(bytes);
    }

    public static byte[] encodeByAes(@Nonnull byte[] dataBytes, @Nonnull byte[] keyBytes, @Nonnull byte[] ivBytes) {
        Cipher cipher = KjyEncryptUtil.generateCipher(keyBytes, ivBytes, AES_KEY_SPEC_NAME, AES_CIPHER_NAME, true);
        try {
            return cipher.doFinal(dataBytes);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static byte[] decodeByAes(@Nonnull byte[] dataBytes, @Nonnull byte[] keyBytes, @Nonnull byte[] ivBytes) {
        Cipher cipher = KjyEncryptUtil.generateCipher(keyBytes, ivBytes, AES_KEY_SPEC_NAME, AES_CIPHER_NAME, false);
        try {
            return cipher.doFinal(dataBytes);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static Cipher generateCipher(byte[] keyBytes, byte[] ivBytes, String keySpecName, String cipherName, boolean encrypt) {
        SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, keySpecName);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(ivBytes);
        try {
            Cipher cipher = Cipher.getInstance(cipherName);
            if (encrypt) {
                cipher.init(1, (Key)secretKeySpec, ivParameterSpec);
            } else {
                cipher.init(2, (Key)secretKeySpec, ivParameterSpec);
            }
            return cipher;
        }
        catch (Exception e) {
            log.error("SignUtil, generate cipher error, key={}, iv={}, keySpecName={}, cipherName={}, encrypt={}", new Object[]{new String(keyBytes), new String(ivBytes), keySpecName, cipherName, encrypt, e});
            throw new IllegalStateException(e);
        }
    }
}

