/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.utils;

import cn.com.duiba.kjy.base.api.utils.MD5Util;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AesUtil {
    private static final Logger log = LoggerFactory.getLogger(AesUtil.class);
    private static String AES_MODE = "AES/CBC/PKCS5Padding";
    private static String CIPHER = "AES";
    private static String CHARSET = "UTF-8";
    private static byte[] IV_BYTES = "efghefghefghefgh".getBytes();

    private static SecretKeySpec generateKey(byte[] password) {
        return new SecretKeySpec(password, CIPHER);
    }

    public static String encryptBase64(String content, String secret) {
        if (content == null || secret == null) {
            return null;
        }
        try {
            SecretKeySpec key = AesUtil.generateKey(secret.getBytes(StandardCharsets.UTF_8));
            byte[] cipherText = AesUtil.encrypt(key, AesUtil.getIvBytes(secret), content.getBytes());
            return Base64.getEncoder().encodeToString(cipherText);
        }
        catch (Exception e) {
            log.error("encrypt error! content={} secret={}", new Object[]{content, secret, e});
            return null;
        }
    }

    public static byte[] encrypt(SecretKeySpec key, byte[] iv, byte[] message) throws Exception {
        Cipher cipher = Cipher.getInstance(AES_MODE);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(1, (Key)key, ivSpec);
        return cipher.doFinal(message);
    }

    public static String decryptBase64(String base64Content, String secret) {
        if (base64Content == null || secret == null) {
            return null;
        }
        try {
            SecretKeySpec key = AesUtil.generateKey(secret.getBytes(StandardCharsets.UTF_8));
            byte[] decodedCipherText = Base64.getDecoder().decode(base64Content);
            byte[] decryptedBytes = AesUtil.decrypt(key, AesUtil.getIvBytes(secret), decodedCipherText);
            return new String(decryptedBytes);
        }
        catch (Exception e) {
            log.error("decryptBase64 error! base64Content={}, secret={}", (Object)base64Content, (Object)secret);
            return null;
        }
    }

    private static byte[] decrypt(SecretKeySpec key, byte[] iv, byte[] decodedCipherText) throws Exception {
        Cipher cipher = Cipher.getInstance(AES_MODE);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        cipher.init(2, (Key)key, ivSpec);
        return cipher.doFinal(decodedCipherText);
    }

    private static byte[] getIvBytes(String secret) {
        String ivString = StringUtils.substring((String)MD5Util.toMD5String(secret), (int)0, (int)16);
        if (ivString == null) {
            return null;
        }
        return ivString.getBytes(StandardCharsets.UTF_8);
    }

    public static void main(String[] args) {
        String secret = "1111111111111111";
        String encryptBase64 = AesUtil.encryptBase64("123456", secret);
        System.out.println(encryptBase64);
        System.out.println(AesUtil.decryptBase64(encryptBase64, secret));
    }
}

