/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.kjj.oss.template;

import cn.com.duibaboot.kjj.oss.template.AbstractOssTemplate;
import java.net.URI;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;

public class PublicBucketOssTemplate
extends AbstractOssTemplate {
    @Override
    public String getUrl(String key) {
        if (StringUtils.isBlank((String)key)) {
            return key;
        }
        String host = this.cdnHost;
        if (StringUtils.isBlank((String)host)) {
            host = this.getBucketHost();
        }
        if (key.startsWith("http")) {
            return key;
        }
        if (key.startsWith("//")) {
            return "https:" + key;
        }
        if (key.startsWith(host)) {
            return "https://" + key;
        }
        if (key.startsWith("/")) {
            return "https://" + host + key;
        }
        return "https://" + host + "/" + key;
    }

    public void afterPropertiesSet() throws Exception {
        URI uri = URI.create(this.endPoint);
        this.bucketHost = this.bucketName + "." + uri.getHost();
        this.bucketDomain = uri.getScheme() + "://" + this.bucketHost;
        if (StringUtils.isNotBlank((String)this.cdnDomain)) {
            URI uri2 = URI.create(this.cdnDomain);
            this.cdnHost = uri2.getHost();
            if (Objects.isNull(this.cdnHost)) {
                throw new RuntimeException("\u975e\u6cd5\u7684oss\u57df\u540d\u914d\u7f6e:" + this.cdnDomain);
            }
        }
    }
}

