/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.queue;

import cn.com.duiba.boot.concurrent.BatchConsumeBlockingQueue;
import cn.com.duiba.kjy.base.api.queue.QueueConsumeService;
import com.dianping.cat.Cat;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public abstract class AbstractQueueConsumeService<T>
implements QueueConsumeService<T>,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(AbstractQueueConsumeService.class);
    private BatchConsumeBlockingQueue<T> queue;

    public AbstractQueueConsumeService(int capacity, int batchSize, int maxWaitTimeMillis) {
        this.queue = new BatchConsumeBlockingQueue(capacity, batchSize, maxWaitTimeMillis, this::batchConsumeMsg);
        this.queue.start();
    }

    @Override
    public void addQueue(T t) {
        String simpleClassName = this.getClass().getSimpleName();
        Cat.logEvent((String)"batchConsumerQueue", (String)simpleClassName);
        try {
            this.queue.add(t);
        }
        catch (Throwable e) {
            Cat.logEvent((String)"batchConsumerQueue", (String)simpleClassName, (String)"fail", (String)"");
            throw e;
        }
    }

    protected abstract void batchConsumeMsg(List<T> var1);

    public void destroy() throws Exception {
        int sleepCnt = 1;
        while (!this.queue.isEmpty()) {
            if (sleepCnt++ > 3) {
                return;
            }
            TimeUnit.SECONDS.sleep(2L);
        }
    }
}

