/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.utils;

import com.google.common.collect.Maps;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(UrlUtils.class);

    private UrlUtils() {
    }

    public static String encoder(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8");
        }
        catch (Exception e) {
            LOGGER.warn("url encoder error url={}", (Object)url, (Object)e);
            return url;
        }
    }

    public static String decoder(String url) {
        try {
            return URLDecoder.decode(url, "UTF-8");
        }
        catch (Exception e) {
            LOGGER.warn("url decoder error url={}", (Object)url, (Object)e);
            return url;
        }
    }

    public static String decodeV2(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return url;
        }
        int i = 0;
        while (i++ < 4) {
            if (url.startsWith("/") || url.startsWith("http:") || url.startsWith("https:")) {
                return url;
            }
            url = UrlUtils.decoder(url);
        }
        return url;
    }

    public static Map<String, String> parseQueryString(String queryString) {
        if (StringUtils.isBlank((CharSequence)queryString)) {
            return Collections.emptyMap();
        }
        int idx = queryString.indexOf(63);
        String paramStr = "";
        paramStr = idx >= 0 ? new String(queryString.substring(idx + 1)) : queryString;
        HashMap map = Maps.newHashMap();
        List list = URLEncodedUtils.parse((String)paramStr, (Charset)Charset.forName("UTF-8"));
        for (NameValuePair pair : list) {
            map.put(pair.getName(), pair.getValue());
        }
        return map;
    }

    public static String getHost(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return "";
        }
        try {
            URI u = new URI(url);
            return u.getHost();
        }
        catch (URISyntaxException e) {
            LOGGER.info("url\u8f6c\u6362\u9519\u8bef {}", (Object)url);
            return "";
        }
    }

    public static String getPath(String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return "";
        }
        try {
            URI u = new URI(url);
            return u.getPath();
        }
        catch (URISyntaxException e) {
            LOGGER.info("url\u8f6c\u6362\u9519\u8bef {}", (Object)url);
            return "";
        }
    }

    public static String getUrl(String url) {
        if (StringUtils.startsWith((CharSequence)url, (CharSequence)"//")) {
            return "https:" + url;
        }
        return url;
    }

    public static String appendQueryParam(String url, String ... infos) {
        if (StringUtils.isEmpty((CharSequence)url) || ArrayUtils.isEmpty((Object[])infos)) {
            return url;
        }
        StringBuilder sb = new StringBuilder(url);
        for (int i = 0; i < infos.length; ++i) {
            String trimInfo = StringUtils.trim((String)infos[i]);
            if (StringUtils.isEmpty((CharSequence)trimInfo)) continue;
            if (sb.indexOf("?") != -1) {
                sb.append('&');
            } else {
                sb.append('?');
            }
            sb.append(trimInfo);
        }
        return sb.toString();
    }

    public static String addRequestParams(String url, String queryString) {
        return UrlUtils.addRequestParams(url, queryString, "cid", "dpm");
    }

    public static String addRequestParams(String url, String queryString, String ... removeParams) {
        if (StringUtils.isBlank((CharSequence)url) || StringUtils.isBlank((CharSequence)queryString)) {
            return url;
        }
        Map<String, String> requestParams = UrlUtils.parseQueryString(queryString);
        if (MapUtils.isEmpty(requestParams)) {
            return url;
        }
        UrlUtils.removeKeys(requestParams, removeParams);
        if (MapUtils.isEmpty(requestParams)) {
            return url;
        }
        Map<String, String> params = UrlUtils.parseQueryString(url);
        if (MapUtils.isNotEmpty(params)) {
            requestParams.keySet().removeIf(params::containsKey);
        }
        if (MapUtils.isEmpty(requestParams)) {
            return url;
        }
        return cn.com.duiba.wolf.utils.UrlUtils.appendParams((String)url, requestParams);
    }

    private static void removeKeys(Map<String, String> requestParams, String ... removeParams) {
        if (MapUtils.isEmpty(requestParams)) {
            return;
        }
        if (removeParams == null || removeParams.length == 0) {
            return;
        }
        for (String param : removeParams) {
            requestParams.remove(param);
        }
    }

    public static String addDomain(String domain, String url) {
        if (StringUtils.isBlank((CharSequence)url)) {
            return "";
        }
        if (url.toLowerCase().startsWith("http")) {
            return url;
        }
        return domain + url;
    }
}

