package cn.com.duiba.kjy.base.customweb.sever;

import cn.com.duiba.kjy.base.customweb.web.handler.DispatcherHandler;
import cn.com.duiba.kjy.base.customweb.web.handler.exception.ExceptionChain;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.timeout.IdleStateHandler;
import lombok.extern.slf4j.Slf4j;


/**
 * @author dugq
 * @date 2020-08-10 15:17
 */
@Slf4j
public class ServerChannelInitializer extends ChannelInitializer<SocketChannel> {
    private DispatcherHandler dispatcherHandler;
    private final ExceptionChain exceptionChain;

    public ServerChannelInitializer(DispatcherHandler dispatcherHandler, ExceptionChain exceptionChain) {
        this.dispatcherHandler = dispatcherHandler;
        this.exceptionChain = exceptionChain;
    }

    @Override
    protected void initChannel(SocketChannel ch) {
        initHandler(ch.pipeline());
    }

    /**
     * @param channelPipeline  channelPipeline
     */
    protected  void initHandler(ChannelPipeline channelPipeline){
        intProtocolHandler(channelPipeline);
        channelPipeline.addLast(new IdleStateHandler(15,0,0));
    }

    private  void intProtocolHandler(ChannelPipeline channelPipeline){

        channelPipeline.addLast("http-decoder",new HttpRequestDecoder());

        channelPipeline.addLast(NettyConstant.AGGREGATOR, new HttpObjectAggregator(65536));

        channelPipeline.addLast("http-encoder",new HttpResponseEncoder());
        //自定义
        channelPipeline.addLast(new KjjChannelInboundHandler(dispatcherHandler,exceptionChain));

    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
//        LoggerUtil.debug(log,"handle added channel = {}",ctx.channel());
        super.handlerAdded(ctx);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
//        LoggerUtil.debug(log,"handle remove channel = {}",ctx.channel());
        super.handlerRemoved(ctx);
    }
}
