package cn.com.duiba.kjy.base.utils;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

@Slf4j
public class BaseListUtils {

    public static <T,K,V> Map<K,V> assembleDoubleList2Map(List<K> keys, List<T> values, BiFunction<K,T,V> valueHandle){
        if (CollectionUtils.isEmpty(keys) || CollectionUtils.isEmpty(values) || keys.size()!=values.size()){
            log.error("list size not equals!");
            return null;
        }
        Map<K,V> result = new HashMap<>();
        for (int i = 0; i< keys.size(); i++) {
            K key = keys.get(i);
            V value = valueHandle.apply(key,values.get(i));
            result.put(key,value);
        }
        return result;
    }
}
