package cn.com.duiba.kjy.base.api.enums.gold;

import java.util.Objects;

/**
 * @author wangbinbin
 * @create 2021-03-04 11:27
 * @descript 黄金宝典同步状态枚举
 */
public enum GoldSyncStatusEnum {

    NOT_SYNC(0, "未同步"),
    SYNCING(1, "同步中"),
    SYNC_SUCCESS(2, "同步成功"),
    SYNC_ERROR(3, "同步失败"),
    ;


    private Integer code;

    private String description;

    GoldSyncStatusEnum(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    /**
     * 可以进行同步的状态码
     */
    public static boolean canSync(Integer code) {
        if (Objects.isNull(code)) {
            return false;
        }
        return Objects.equals(code, NOT_SYNC.code) || Objects.equals(code, SYNC_ERROR.getCode());
    }
}
