package cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller;

import cn.com.duiba.kjy.base.customweb.autoconfig.MappingCrosDomainConfig;
import cn.com.duiba.kjy.base.customweb.web.bean.ParameterBean;
import cn.com.duiba.kjy.base.customweb.web.bean.RequestTypeEnum;
import cn.com.duiba.kjy.base.customweb.web.handler.response.ResponseHandler;
import lombok.Data;

import java.lang.reflect.Method;
import java.util.List;

/**
 * @author dugq
 * @date 2021/3/23 7:16 下午
 * @see ControllerMappingHandler
 */
@Data
public class ControllerMappingHandlerBuilder {

    private Class<?> handlerClass;

    private Method handlerMethod;

    private String handler;

    private List<ParameterBean> paramList;

    private RequestTypeEnum requestType;

    private RequestMappingInfo requestMappingInfo;

    private Class<?> returnType;

    private Object handlerObject;

    private ResponseHandler responseHandler;

    private MappingCrosDomainConfig config;

    public ControllerMappingHandler build(){
        return new ControllerMappingHandler(handlerClass,handler,handlerMethod,paramList,requestType,requestMappingInfo,returnType,handlerObject,responseHandler,config);
    }

    public static ControllerMappingHandlerBuilder create(Class<?> handlerBeanClass, Method method){
        final ControllerMappingHandlerBuilder controllerMappingHandlerBuilder = new ControllerMappingHandlerBuilder();
        controllerMappingHandlerBuilder.setHandlerMethod(method);
        controllerMappingHandlerBuilder.setHandlerClass(handlerBeanClass);
        return controllerMappingHandlerBuilder;
    }

}
