package cn.com.duiba.kjy.base.api.dto.clue.open;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 第三方直播线索实时统计dto
 *
 * @author xuzhigang
 * @date 2022/4/7 10:47 上午
 **/
@Data
public class LiveClueOpenRealTimeStatDto implements Serializable {
    private static final long serialVersionUID = -1554635492733837229L;

    /**
     * 直播线索
     * {@link cn.com.duiba.kjy.base.api.enums.clue.open.LiveOpenClueTypeEnum}
     */
    private Integer openClueType;

    /**
     * 直播id
     */
    private Long liveId;

    /**
     * 访客id集合
     */
    private List<Long> liveUserIds;

    /**
     * 代理人id集合
     */
    private List<Long> agentIds;
}
