package cn.com.duiba.kjy.base.api.request;

/**
 * @author dugq
 * @date 2021/11/8 2:06 下午
 */
public interface ErrorCodeInterface {
    /**
     * 默认成功码
     */
     String DEFAULT_SUCCESS_CODE = "000000";
    /**
     * 默认错误码
     */
    String DEFAULT_FAIL_CODE = "999999";

    /**
     * 标示系统
     * @return
     */
    default String getHost(){
        return "00";
    }

    /**
     * 返回错误码
     * @return
     */
    default String getCode(){
        return getHost()+ getShortCode();
    }
    /**
     * 错误码的前两位为功能模块标示
     * @return
     */
    default String getModule(){
        return getShortCode().substring(0,2);
    }


    /**
     * 开发自定义错误码
     * @return
     */
    String getShortCode();

    /**
     * 错误码的描述
     * @return
     */
    String getDesc();
}
