package cn.com.duiba.kjy.base.customweb.autoconfig;

import lombok.Getter;
import lombok.Setter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@Getter
@Setter
public class MappingCrosDomainConfig {

    private static final List<HttpMethod> DEFAULT_METHODS = Collections.unmodifiableList(
            Arrays.asList(HttpMethod.GET, HttpMethod.HEAD));

    private static final List<String> DEFAULT_PERMIT_METHODS = Collections.unmodifiableList(
            Arrays.asList(HttpMethod.GET.name(), HttpMethod.HEAD.name(), HttpMethod.POST.name()));

    @Nullable
    private List<String> allowedOrigins;

    @Nullable
    private List<String> allowedHeaders;

    @Nullable
    private List<String> exposedHeaders;

    @Nullable
    private Boolean allowCredentials;

    @Nullable
    private Long maxAge;

    public String checkOrigin(String requestOrigin) {
        if (CollectionUtils.isEmpty(allowedOrigins)){
            return null;
        }
        for (String allowedOrigin : allowedOrigins) {
            if (StringUtils.equals(allowedOrigin,requestOrigin)){
                return requestOrigin;
            }
        }
        return null;
    }

    public List<String> checkHeaders(List<String> requestHeaders) {
        if (requestHeaders == null) {
            return null;
        }
        if (requestHeaders.isEmpty()) {
            return Collections.emptyList();
        }
        //未经过springMVC处理的原始header，用逗号隔开的
        List<String> allHeaders = requestHeaders.stream().map(headerValue -> headerValue.split(",")).flatMap(Arrays::stream).map(String::trim).collect(Collectors.toList());

        if (ObjectUtils.isEmpty(this.allowedHeaders)) {
            return null;
        }

        boolean allowAnyHeader = this.allowedHeaders.contains("*");
        List<String> result = new ArrayList<>(allHeaders.size());
        for (String requestHeader : allHeaders) {
            if (org.springframework.util.StringUtils.hasText(requestHeader)) {
                requestHeader = requestHeader.trim();
                if (allowAnyHeader) {
                    result.add(requestHeader);
                }
                else {
                    for (String allowedHeader : this.allowedHeaders) {
                        if (requestHeader.equalsIgnoreCase(allowedHeader)) {
                            result.add(requestHeader);
                            break;
                        }
                    }
                }
            }
        }
        return (result.isEmpty() ? null : result);
    }
}
