package cn.com.duiba.kjy.base.customweb.web.condition;

import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import org.springframework.lang.Nullable;


/**
 * @author dugq
 * @date 2021/4/1 3:07 下午
 */public interface RequestCondition<T>{
    /**
     * Combine this condition with another such as conditions from a
     * type-level and method-level {@code @RequestMapping} annotation.
     * @param other the condition to combine with.
     * @return a request condition instance that is the result of combining
     * the two condition instances.
     */
    T combine(T other);

    /**
     * Check if the condition matches the request returning a potentially new
     * instance created for the current request. For example a condition with
     * multiple URL patterns may return a new instance only with those patterns
     * that match the request.
     * <p>For CORS pre-flight requests, conditions should match to the would-be,
     * actual request (e.g. URL pattern, query parameters, and the HTTP method
     * from the "Access-Control-Request-Method" header). If a condition cannot
     * be matched to a pre-flight request it should return an instance with
     * empty content thus not causing a failure to match.
     * @return a condition instance in case of a match or {@code null} otherwise.
     */
    @Nullable
    boolean getMatchingCondition(KjjHttpRequest request);

    /**
     * Compare this condition to another condition in the context of
     * a specific request. This method assumes both instances have
     * been obtained via
     * to ensure they have content relevant to current request only.
     */
    int compareTo(T other, KjjHttpRequest request);
}
