/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.util;

import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import io.netty.handler.codec.http.cookie.Cookie;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.ApplicationContext;

public class PerfTestUtil {
    public static final String PERF_TEST_KEY = "_duibaPerf";
    public static final String PERF_TEST_SCENE_ID_KEY = "_duibaPerfSceneId";
    public static final String PERF_TEST_CLUSTER = "_duibaPerfTestCluster";
    public static final String IS_PERF_TEST_MODE_HEADER_KEY = "isPerfTestMode";
    public static final String DUIBA_PERF_SCENE_ID = "duiba.perf.scene.id";

    private PerfTestUtil() {
    }

    public static boolean isPerfTestRequest(KjjHttpRequest request) {
        String perfTestHeader;
        boolean isTestMode = PerfTestUtil.isPerfTestFromParameter(request);
        if (!isTestMode && (perfTestHeader = request.getHeader(PERF_TEST_KEY)) != null && ("1".equals(perfTestHeader) || "true".equals(perfTestHeader))) {
            isTestMode = true;
        }
        if (!isTestMode && "true".equals(request.getHeader(IS_PERF_TEST_MODE_HEADER_KEY))) {
            isTestMode = true;
        }
        return isTestMode;
    }

    public static String getPerfTestSceneId(KjjHttpRequest request) {
        List<Cookie> cookies;
        if (!PerfTestUtil.isPerfTestRequest(request)) {
            return null;
        }
        String sceneId = request.getParameter(PERF_TEST_SCENE_ID_KEY);
        if (StringUtils.isBlank((CharSequence)sceneId) && (cookies = request.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                if (!PERF_TEST_SCENE_ID_KEY.equals(cookie.name())) continue;
                sceneId = cookie.value();
            }
        }
        if (StringUtils.isBlank((CharSequence)sceneId)) {
            sceneId = request.getHeader(PERF_TEST_SCENE_ID_KEY);
        }
        return sceneId;
    }

    public static boolean isPerfTestCluster(KjjHttpRequest request) {
        List<Cookie> cookies;
        if (!PerfTestUtil.isPerfTestRequest(request)) {
            return false;
        }
        String isTestCluster = request.getParameter(PERF_TEST_CLUSTER);
        if (StringUtils.isBlank((CharSequence)isTestCluster) && (cookies = request.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                if (!PERF_TEST_CLUSTER.equals(cookie.name())) continue;
                isTestCluster = cookie.value();
            }
        }
        if (StringUtils.isBlank((CharSequence)isTestCluster)) {
            isTestCluster = request.getHeader(PERF_TEST_CLUSTER);
        }
        return "1".equals(isTestCluster) || "true".equals(isTestCluster);
    }

    private static boolean isPerfTestFromParameter(KjjHttpRequest request) {
        boolean isTestMode = false;
        String testInParameter = request.getParameter(PERF_TEST_KEY);
        if (testInParameter != null && ("1".equals(testInParameter) || "true".equals(testInParameter))) {
            isTestMode = true;
        } else {
            List<Cookie> cookies = request.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!PERF_TEST_KEY.equals(cookie.name()) || !"1".equals(cookie.value()) && !"true".equals(cookie.value())) continue;
                    isTestMode = true;
                }
            }
        }
        return isTestMode;
    }

    public static String getThisServerDuibaPerfSceneId(ApplicationContext applicationContext) {
        return applicationContext.getEnvironment().getProperty(DUIBA_PERF_SCENE_ID);
    }
}

