/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.reactive.convert;

import cn.com.duiba.kjy.base.reactive.convert.IdDecode;
import cn.com.duiba.kjy.base.reactive.convert.IdDecodeBean;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.MediaType;
import org.springframework.http.ReactiveHttpInputMessage;
import org.springframework.http.codec.HttpMessageReader;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class HttpReader
extends IdDecodeBean
implements HttpMessageReader<Object> {
    private static final Logger log = LoggerFactory.getLogger(HttpReader.class);
    private int maxInMemorySize = 262144;

    public List<MediaType> getReadableMediaTypes() {
        return Collections.singletonList(MediaType.APPLICATION_JSON);
    }

    public boolean canRead(ResolvableType elementType, MediaType mediaType) {
        Type type = elementType.getType();
        if (type instanceof Class) {
            Class clazz = (Class)type;
            IdDecode annotation = clazz.getAnnotation(IdDecode.class);
            return Objects.nonNull(annotation);
        }
        return false;
    }

    public Mono<Object> readMono(@NotNull ResolvableType elementType, ReactiveHttpInputMessage message, @NotNull Map hints) {
        return DataBufferUtils.join((Publisher)message.getBody(), (int)this.maxInMemorySize).flatMap(dataBuffer -> Mono.justOrEmpty((Object)this.decode((DataBuffer)dataBuffer, elementType, hints)));
    }

    private Object decode(DataBuffer dataBuffer, ResolvableType elementType, Map hints) {
        try {
            String requestBody = IOUtils.toString((InputStream)dataBuffer.asInputStream(), (String)"UTF-8");
            Class clazz = (Class)elementType.getType();
            JSONObject jsonObject = JSONObject.parseObject((String)requestBody);
            List<Field> allFields = this.getAllFields(clazz);
            this.deCodeEncodingFiled(jsonObject, allFields);
            return JSONObject.parseObject((String)jsonObject.toJSONString(), (Class)clazz);
        }
        catch (IOException e) {
            log.error("there is something error when decode request body", (Throwable)e);
            return null;
        }
    }

    @Override
    protected List<Field> getAllFields(Class clazz) {
        if (Objects.isNull(clazz) || clazz.isInterface()) {
            return Collections.emptyList();
        }
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != Object.class) {
            fieldList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
            clazz = clazz.getSuperclass();
        }
        return fieldList;
    }

    public Flux read(ResolvableType elementType, ReactiveHttpInputMessage message, Map hints) {
        return null;
    }

    private void deCodeEncodingFiled(JSONObject jsonObject, List<Field> declaredFields) {
        if (Objects.isNull(jsonObject)) {
            return;
        }
        for (Field field : declaredFields) {
            IdDecode annotation = field.getAnnotation(IdDecode.class);
            if (!Objects.nonNull(annotation)) continue;
            if (this.isPrimitiveOrString(field.getType())) {
                Long id = this.decodeId(annotation, jsonObject.getString(field.getName()), field.getType(), field.getName());
                jsonObject.put(field.getName(), (Object)id);
                continue;
            }
            if (this.isMap(field.getType()).booleanValue()) {
                throw new UnsupportedOperationException("\u4e0d\u652f\u6301map\u54e6\u3002\u4e0d\u5efa\u8bae\u5165\u53c2\u4f7f\u7528map\u63a5\u6536");
            }
            if (this.isArray(field.getType()).booleanValue() || this.isCollection(field.getType()).booleanValue()) {
                JSONArray jsonArray = jsonObject.getJSONArray(field.getName());
                if (Objects.isNull(jsonArray) || annotation.type() == Object.class) continue;
                if (this.isPrimitiveOrString(annotation.type())) {
                    List ids = jsonArray.stream().map(value -> this.decodeId(annotation, value.toString(), field.getType(), field.getName())).collect(Collectors.toList());
                    jsonObject.put(field.getName(), ids);
                    continue;
                }
                if (this.isArray(annotation.type()).booleanValue() || this.isCollection(annotation.type()).booleanValue() || this.isMap(annotation.type()).booleanValue()) {
                    throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u77e9\u9635");
                }
                for (int i = 0; i < jsonArray.size(); ++i) {
                    this.deCodeEncodingFiled(jsonArray.getJSONObject(i), this.getAllFields(annotation.type()));
                }
                continue;
            }
            this.deCodeEncodingFiled(jsonObject.getJSONObject(field.getName()), this.getAllFields(field.getType()));
        }
    }
}

