package cn.com.duiba.kjy.base.api.configuration;

import cn.com.duiba.kjy.base.api.request.iddecode.IdArgumentConvert;
import cn.com.duiba.kjy.base.api.request.iddecode.IdArgumentResolver;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

import java.util.List;

/**
 * @author dugq
 * @date 2021/11/8 3:20 下午
 */
@Configuration
public class IdConfiguration implements WebMvcConfigurer {

    @Override
    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add(getIdArgumentConvert());
    }


    @Override
    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(getIdArgumentResolver());
    }


    @Bean
    public IdArgumentResolver getIdArgumentResolver(){
        return new IdArgumentResolver();
    }

    @Bean
    public IdArgumentConvert getIdArgumentConvert(){
        return new IdArgumentConvert();
    }
}
