package cn.com.duiba.kjy.base.api.response;

import cn.com.duiba.kjy.base.api.request.Result;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;

/**
 * Created by zhangshun on 2019/2/28.
 */
@Slf4j
public class ResponseUtils {

    private ResponseUtils() {
        //to do something
    }

    public static <T> void out(HttpServletResponse response, Result<T> result) {
        response.setContentType("application/json;charset=UTF-8");
        try {
            doResponse(response, JSON.toJSONString(result));
        } catch (IOException e) {
            log.warn("response close");
        }
    }

    public static void out(HttpServletResponse response, String content) throws IOException {
        response.setContentType("text/html; charset=utf-8");
        doResponse(response, content);
    }

    private static void doResponse(HttpServletResponse response, String content) throws IOException {
        response.setStatus(200);
        PrintWriter out = response.getWriter();
        out.print(content);
        out.flush();
        out.close();
    }

}
