package cn.com.duiba.kjy.base.api.service.datasource;

import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

import javax.sql.DataSource;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;

/**
 * @author dugq
 * @date 2021/4/21 6:08 下午
 */
public class DbMovingDataSource extends AbstractRoutingDataSource {
    private final DataSource oldDataSource;
    private final DataSource newDataSource;
    private final String redisKey;
    private static final String OLD_KEY = "old";
    private static final String NEW_KEY = "new";

    private  final Function<String,String> getFlagFunction;

    public DbMovingDataSource(DataSource oldDataSource, DataSource newDataSource, String redisKey,Function<String,String> getFlagFunction) {
        this.oldDataSource = oldDataSource;
        this.newDataSource = newDataSource;
        this.redisKey = redisKey;
        this.getFlagFunction = getFlagFunction;
    }

    public void afterPropertiesSet(){
        HashMap<Object, Object> targetDataSource = new HashMap<>();
        targetDataSource.put(OLD_KEY,oldDataSource);
        targetDataSource.put(NEW_KEY,newDataSource);
        setTargetDataSources(targetDataSource);
        setDefaultTargetDataSource(oldDataSource);
        super.afterPropertiesSet();
    }

    @Override
    protected Object determineCurrentLookupKey() {
        try {
            String flag = getFlag();
            if (Objects.nonNull(flag) && StringUtils.equals(flag,"1")){
                return NEW_KEY;
            }
            return OLD_KEY;
        }catch (Exception e){
           logger.error("get key from redis has error!",e);
           return OLD_KEY;
        }
    }

    public String getFlag() {
        return getFlagFunction.apply(this.redisKey);
    }
}
