package cn.com.duiba.kjy.base.customweb.web.codec.convert;

import cn.com.duiba.kjy.base.api.utils.IdMakeUtil;
import cn.com.duiba.kjy.base.customweb.web.codec.IdDecode;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;

/**
 * @author dugq
 * @date 2021/3/28 9:57 下午
 */
@Slf4j
public class IdDecodeConvert implements ConditionalGenericConverter {


    @Override
    public Set<ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new ConvertiblePair(String.class,Long.class));
    }

    @Override
    public Object convert(Object source, @NotNull TypeDescriptor sourceType, @NotNull TypeDescriptor targetType) {
        if (Objects.isNull(source)){
            return null;
        }
        if (source instanceof String){
            final String sourceString = (String) source;
            return decodeId(sourceString);
        }else{
            log.error("can not convert target={} to Long.class",source);
            return null;
        }
    }

    @Nullable
    private Long decodeId(String sourceString) {
        final Long id = IdMakeUtil.decodingId(sourceString);
        if (Objects.isNull(id) && StringUtils.isNotBlank(sourceString)){
            //这里不能抛出异常，因为convert也是作为对象属性映射的处理方案，如果抛出了异常，
            //那属性映射时就会走降级方案，导致数字可以直接传递到handlerMapping中,
            //但是设计上为了保证所有的异常都能被调用用知道，所以这些错误应该以异常的方式抛出去，由客户端自行处理，后续考虑如何跳过spring的降级处理
            return null;
        }else{
            return id;
        }
    }

    @Override
    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return targetType.hasAnnotation(IdDecode.class);
    }
}
