/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.api.request;

import cn.com.duiba.kjy.base.api.request.ErrorCodeInterface;
import cn.com.duiba.kjy.base.api.request.Result;

public final class ResultBuilders {
    private ResultBuilders() {
    }

    public static <T> Result<T> fail(String code, String desc) {
        Result result = new Result();
        result.setTimestamp(System.currentTimeMillis());
        result.setSuccess(false);
        result.setCode(code);
        result.setDesc(desc);
        return result;
    }

    public static <T> Result<T> fail(String desc) {
        return ResultBuilders.fail("999999", desc);
    }

    public static <T> Result<T> fail(ErrorCodeInterface errCode) {
        return ResultBuilders.fail(errCode.getCode(), errCode.getDesc());
    }

    public static <T> Result<T> fail(ErrorCodeInterface errCode, T data) {
        Result<T> result = new Result<T>();
        result.setTimestamp(System.currentTimeMillis());
        result.setSuccess(false);
        result.setCode(errCode.getCode());
        result.setDesc(errCode.getDesc());
        result.setData(data);
        return result;
    }

    public static <T> Result<T> fail(String desc, T data) {
        return ResultBuilders.fail("999999", desc, data);
    }

    public static <T> Result<T> fail(String code, String desc, T data) {
        Result<T> result = new Result<T>();
        result.setTimestamp(System.currentTimeMillis());
        result.setSuccess(false);
        result.setCode(code);
        result.setDesc(desc);
        result.setData(data);
        return result;
    }

    public static <T> Result<T> success(String code, T data) {
        Result<T> result = new Result<T>();
        result.setTimestamp(System.currentTimeMillis());
        result.setSuccess(true);
        result.setCode(code);
        result.setData(data);
        result.setDesc("OK");
        return result;
    }

    public static <T> Result<T> success(T data) {
        return ResultBuilders.success("000000", data);
    }

    public static <T> Result<T> success() {
        return ResultBuilders.success("000000", null);
    }
}

