/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.base.customweb.web.handler.mapping.controller;

import cn.com.duiba.kjy.base.customweb.web.bean.KjjHttpRequest;
import cn.com.duiba.kjy.base.customweb.web.condition.PatternsRequestCondition;
import cn.com.duiba.kjy.base.customweb.web.condition.RequestCondition;
import cn.com.duiba.kjy.base.customweb.web.condition.RequestMethodsRequestCondition;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMethod;

public class RequestMappingInfo
implements RequestCondition<RequestMappingInfo> {
    @Nullable
    private final String name;
    private final PatternsRequestCondition patternsCondition;
    private final RequestMethodsRequestCondition methodCondition;

    public RequestMappingInfo(@Nullable String name, @Nullable PatternsRequestCondition patterns, RequestMethodsRequestCondition methodCondition) {
        this.name = StringUtils.hasText((String)name) ? name : null;
        this.patternsCondition = patterns != null ? patterns : new PatternsRequestCondition(new String[0]);
        this.methodCondition = methodCondition;
    }

    public RequestMappingInfo(@Nullable PatternsRequestCondition patterns, RequestMethodsRequestCondition methodCondition) {
        this(null, patterns, methodCondition);
    }

    public RequestMappingInfo(RequestMappingInfo info) {
        this(info.name, info.patternsCondition, info.methodCondition);
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public PatternsRequestCondition getPatternsCondition() {
        return this.patternsCondition;
    }

    @Override
    public RequestMappingInfo combine(RequestMappingInfo other) {
        String name = this.combineNames(other);
        PatternsRequestCondition patterns = this.patternsCondition.combine(other.patternsCondition);
        RequestMethodsRequestCondition methods = this.methodCondition.combine(other.methodCondition);
        return new RequestMappingInfo(name, patterns, methods);
    }

    @Nullable
    private String combineNames(RequestMappingInfo other) {
        if (this.name != null && other.name != null) {
            String separator = "#";
            return this.name + separator + other.name;
        }
        if (this.name != null) {
            return this.name;
        }
        return other.name;
    }

    @Override
    public boolean getMatchingCondition(KjjHttpRequest request) {
        boolean urlMath = this.patternsCondition.getMatchingCondition(request);
        if (!urlMath) {
            return false;
        }
        return this.methodCondition.getMatchingCondition(request);
    }

    @Override
    public int compareTo(RequestMappingInfo other, KjjHttpRequest request) {
        int result = this.patternsCondition.compareTo(other.getPatternsCondition(), request);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RequestMappingInfo)) {
            return false;
        }
        RequestMappingInfo otherInfo = (RequestMappingInfo)other;
        return this.patternsCondition.equals(otherInfo.patternsCondition);
    }

    public int hashCode() {
        return this.patternsCondition.hashCode() * 31;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        if (!this.patternsCondition.isEmpty()) {
            Set<String> patterns = this.patternsCondition.getPatterns();
            builder.append(" ").append(patterns.size() == 1 ? patterns.iterator().next() : patterns);
        }
        builder.append('}');
        return builder.toString();
    }

    public static Builder paths(String ... paths) {
        return new DefaultBuilder(paths);
    }

    private static class DefaultBuilder
    implements Builder {
        private String[] paths = new String[0];
        private RequestMethod[] methods = new RequestMethod[0];
        @Nullable
        private String mappingName;
        private BuilderConfiguration options = new BuilderConfiguration();

        public DefaultBuilder(String ... paths) {
            this.paths = paths;
        }

        @Override
        public Builder paths(String ... paths) {
            this.paths = paths;
            return this;
        }

        @Override
        public DefaultBuilder methods(RequestMethod ... methods) {
            this.methods = methods;
            return this;
        }

        @Override
        public DefaultBuilder mappingName(String name) {
            this.mappingName = name;
            return this;
        }

        @Override
        public Builder options(BuilderConfiguration options) {
            this.options = options;
            return this;
        }

        @Override
        public RequestMappingInfo build() {
            PatternsRequestCondition patternsCondition = new PatternsRequestCondition(this.paths, this.options.getPathMatcher());
            return new RequestMappingInfo(this.mappingName, patternsCondition, new RequestMethodsRequestCondition(this.methods));
        }
    }

    public static class BuilderConfiguration {
        @Nullable
        private PathMatcher pathMatcher;

        public void setPathMatcher(@Nullable PathMatcher pathMatcher) {
            this.pathMatcher = pathMatcher;
        }

        @Nullable
        public PathMatcher getPathMatcher() {
            return this.pathMatcher;
        }
    }

    public static interface Builder {
        public Builder paths(String ... var1);

        public Builder methods(RequestMethod ... var1);

        public Builder mappingName(String var1);

        public Builder options(BuilderConfiguration var1);

        public RequestMappingInfo build();
    }
}

