/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duibaboot.kjj.oss.template.support;

import cn.com.duibaboot.kjj.oss.template.operation.MultipartTask;
import com.aliyun.oss.model.ObjectMetadata;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiUploadSupport {
    private static final Logger log = LoggerFactory.getLogger(MultiUploadSupport.class);
    private static final int partSize = 0x200000;

    public static boolean simpleMultipartUpload(MultipartTask multipartTask, InputStream inputStream, String objectName, ObjectMetadata meta) throws IOException {
        boolean createResult = multipartTask.startMultipartPartUpload(objectName, meta);
        if (!createResult) {
            return false;
        }
        List<byte[]> partList = MultiUploadSupport.splitStream(inputStream);
        int partListSize = partList.size();
        for (int i = 0; i < partListSize; ++i) {
            boolean result = MultiUploadSupport.uploadMultipart(multipartTask, i, partList.get(i));
            if (result) continue;
            return false;
        }
        return true;
    }

    private static boolean uploadMultipart(MultipartTask multipartTask, int i, byte[] bytes) {
        boolean result = multipartTask.multipartPartUpload(new ByteArrayInputStream(bytes), Long.valueOf(bytes.length), i);
        if (!result) {
            result = multipartTask.multipartPartUpload(new ByteArrayInputStream(bytes), Long.valueOf(bytes.length), i);
            return result;
        }
        return true;
    }

    private static List<byte[]> splitStream(InputStream inputStream) throws IOException {
        LinkedList<byte[]> linkedList = new LinkedList<byte[]>();
        byte[] buffer;
        int read;
        while ((read = inputStream.read(buffer = new byte[0x200000])) != -1) {
            linkedList.add(buffer);
        }
        return linkedList;
    }
}

