package cn.com.duiba.kjy.api.constant;

import java.io.Serializable;

/**
 * Created by zhangshun on 2019/2/20.
 */
public enum SellerPayStatusEnum implements Serializable {

    WAIT(1, "待付款"),
    IN_PAY(2, "付款中"),
    SUCCEED(3, "付款成功"),
    FAILED(4, "付款失败"),
    CANCELED(5, "取消支付"),
    EXCEPTION(6, "支付异常"),

    ;

    private Integer code;
    private String desc;

    SellerPayStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
