package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.PayResultDto;
import cn.com.duiba.kjy.api.dto.SellerPayRecordDto;

/**
 * Created by zhangshun on 2019/2/20.
 */
@AdvancedFeignClient
public interface RemoteSellerPayRecordService {

    /**
     * 根据销售员ID和支付状态查询
     * @param sellerId
     * @return
     */
    SellerPayRecordDto findBySellerWaitInPay(Long sellerId);

    /**
     * 获取交易号
     * @return
     */
    SellerPayRecordDto addPayRecord(SellerPayRecordDto dto);

    /**
     * 更新状态
     * @param id ID
     * @param status 状态值
     * @return
     */
    Boolean updateStatus(Long id, Integer status);

    Boolean error(String tradeNum, String errorMessage);

    /**
     * 根据交易号查询
     * @param tradeNo 交易流水号
     * @return
     */
    SellerPayRecordDto findByTradeNo(String tradeNo);

    /**
     * 支付结果处理
     * @param payResultDto
     * @return
     */
    Boolean handlePayResult(PayResultDto payResultDto);
}
