/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.kjy.api.constant;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public enum ContentTypeEnum {
    ARTICLE("article", "\u6587\u7ae0"),
    ACTIVITY("activity", "\u6d3b\u52a8"),
    DAILY("daily", "\u65e9\u62a5"),
    POSTER("poster", "\u6d77\u62a5"),
    SELLER("seller", "\u9500\u552e\u5458\u540d\u7247"),
    OUTER_MARKET("outer_market", "\u8170\u5c01\u81ea\u5b9a\u4e49\u94fe\u63a5"),
    OUTER_EXCLUSIVE("outer_exclusive", "\u4e13\u533a\u81ea\u5b9a\u4e49\u94fe\u63a5");

    private String code;
    private String desc;
    private static final Map<String, ContentTypeEnum> ENUM_MAP;

    private ContentTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    public static ContentTypeEnum getByCode(String code) {
        ContentTypeEnum result = ENUM_MAP.get(code);
        if (result == null) {
            return null;
        }
        return result;
    }

    public static boolean isContent(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.ARTICLE.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.ACTIVITY.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.DAILY.code) || StringUtils.equals((String)type, (String)ContentTypeEnum.POSTER.code);
    }

    public static boolean isMarket(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.OUTER_MARKET.code);
    }

    public static boolean isExclusive(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.OUTER_EXCLUSIVE.code);
    }

    public static boolean isSeller(String type) {
        return StringUtils.equals((String)type, (String)ContentTypeEnum.SELLER.code);
    }

    static {
        ENUM_MAP = new HashMap<String, ContentTypeEnum>();
        for (ContentTypeEnum type : ContentTypeEnum.values()) {
            ENUM_MAP.put(type.getCode(), type);
        }
    }
}

