package cn.com.duiba.kjy.api.util;


/**
 * Created by dugq on 2019-02-21.
 */
public enum ErrorCode implements ErrorCodeInterface {
    //00 : 内容
    N000000("内容模块"),
    N000001("内容主表插入失败"),
    N000002("内容扩展表插入失败"),


    //01 销售模块
    N010000("销售模块"),
    N010001("更新用户信息错误"),
    N010002("支付记录状态错误"),

    //02 用户模块
    N020000("用户模块"),
    N020001("保存用户信息错误"),
    N020002("保存用户扩展信息错误"),
    N020003("更新用户信息错误"),
    N020004("保存用户扩展信息错误"),
    N020005("更新用户扩展信息错误"),
        ;

    private String shortCode;
    private String desc;

    ErrorCode( String desc) {
        this.shortCode = this.name().substring(1);
        this.desc = desc;
    }

    @Override
    public String getHost() {
        return "01";
    }

    @Override
    public String getShortCode() {
        return shortCode;
    }

    public String getDesc() {
        return desc;
    }
}
