package cn.com.duiba.kjy.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.SellerDto;
import cn.com.duiba.kjy.api.dto.SellerUserDto;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.kjy.api.params.SearchVipSellerParam;
import cn.com.duiba.kjy.api.params.SellerCardParam;

/**
 * Created by zhangshun on 2019/2/13.
 */
@AdvancedFeignClient
public interface RemoteSellerService {

    /**
     * 通过id查询销售信息
     * @param sellerId
     * @return
     */
    SellerDto findById(Long sellerId);

    /**
     * 根据用户ID查询
     * @param userId 用户ID
     * @return
     */
    SellerDto findByUserId(Long userId);

    /**
     * 查询付费会员列表
     * @param param
     * @return
     */
    Page<SellerDto> searchVipSellerList(SearchVipSellerParam param);

    SellerUserDto findSellerUserById(Long sellerId);

    /**
     *
     * @param dto
     * @return  0L 失败 其他为id
     */
    Long insert(SellerDto dto);

    Boolean update(SellerDto dto);

    /**
     * 更新销售二维码
     * @param qrCode
     * @param id
     * @return
     */
    int updateQrCodeById(String qrCode, Long id);

    /**
     * 更新用户通知设置
     * @param sellerId
     * @param state
     * @return
     */
    int updateNotificationSetting(Long sellerId,Integer state);


    /**
     * 更新销售名片
     * @param param
     * @return
     */
    int editMyCard(SellerCardParam param);
}
