package cn.com.duiba.kjy.api.remoteservice.exclusive;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.exclusive.ExclusiveAreaDto;
import cn.com.duiba.kjy.api.params.exclusive.ExclusiveAreaQryParams;

import java.util.List;

/**
 * 专区remote
 * @author zhanghuifeng
 * date 2019-04-29-19:48
 */
@AdvancedFeignClient
public interface RemoteExclusiveAreaService {

    /**
     * 分页查询数据
     * @param params
     * @return
     */
    List<ExclusiveAreaDto> findPageList(ExclusiveAreaQryParams params);

    /**
     * 分页查询 获取总条数
     * @param params
     * @return
     */
    int findPageCount(ExclusiveAreaQryParams params);

    /**
     * 添加
     * @param dto
     * @return
     */
    Boolean add(ExclusiveAreaDto dto);

    /**
     * 更新
     * @param dto
     * @return
     */
    Boolean update(ExclusiveAreaDto dto);

    /**
     * 根据公司ID获取数据
     * @param companyId
     * @return
     */
    ExclusiveAreaDto findByCompanyId(Long companyId);

    /**
     * 删除
     * @param id
     * @return
     */
    Boolean delete(Long id);

    /**
     * 查询
     * @param id
     * @return
     */
    ExclusiveAreaDto findById(Long id);

    /**
     * 根据公司ID和专区名称查询
     * @param companyId
     * @param title
     * @return
     */
    List<ExclusiveAreaDto> findByCompanyIdAndTitle(Long companyId, String title);

    /**
     * 根据公司ID获取数据
     * @param companyId
     * @return
     */
    List<ExclusiveAreaDto> listByCompanyId(Long companyId);
}
