package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.seller.SellerAccountDto;
import cn.com.duiba.kjy.api.params.WithdrawParams;

/**
 * 销售员账户服务
 * @author zhanghuifeng
 * date 2019-05-20-17:26
 */
@AdvancedFeignClient
public interface RemoteSellerAccService {

    /**
     * 新增账户
     * @param dto
     * @return
     */
    Boolean add(SellerAccountDto dto);

    /**
     * 根据销售员ID获取账户信息
     * @param sellerId
     * @return
     */
    SellerAccountDto getBySellerId(Long sellerId);

    /**
     * 提现
     * @param params
     * @return
     */
    Boolean withdraw(WithdrawParams params);
}
