package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.seller.SellerDistributionCountDto;

import java.util.List;

/**
 * 销售员分销绑定关系服务
 * @author zhanghuifeng
 * date 2019-05-22-14:24
 */
@AdvancedFeignClient
public interface RemoteSellerDistributionService {

    /**
     * 根据上级销售员ID集合和绑定的下级销售员返现状态
     * 查询绑定下级销售员数
     * @param superiorIds
     * @param hasPromotion
     * @see cn.com.duiba.kjy.api.enums.seller.PromotionStateEnum
     * @return
     */
    List<SellerDistributionCountDto> findBySuperiorIdsAndStatus(List<Long> superiorIds, Integer hasPromotion);

    /**
     * 获取当前销售员下绑定人数
     * @param superiorId
     * @return
     */
    int findCountBySuperiorId(Long superiorId);
}
