package cn.com.duiba.kjy.api.remoteservice.vip;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.vip.SellerVipDto;

import java.util.List;

/**
 * Created by zzy on  2019/05/26 14:37
 */
@AdvancedFeignClient
public interface RemoteSellerVipService {
    /**
     * 插入数据
     *
     * @param sellerVipDto
     * @return
     */
    Long insert(SellerVipDto sellerVipDto);

    /**
     * 补充seller_id
     *
     * @param oaId
     * @param openId
     * @param sellerId
     * @return
     */
    boolean modifySellerId(String oaId, String openId, Long sellerId);

    /**
     * 根据id查找
     *
     * @param id
     * @return
     */
    SellerVipDto findById(Long id);

    /**
     * 根据oaId和openId查找
     *
     * @param oaId
     * @param openId
     * @return
     */
    SellerVipDto findByOaIdAndOpenId(String oaId, String openId);

    /**
     * 根据seller_id查找
     *
     * @param sellerId
     * @return
     */
    List<SellerVipDto> findBySellerId(Long sellerId);


    /**
     * 修改用户关注公众号状态
     *
     * @param oaId
     * @param openId
     * @param subscribe
     * @return
     */
    boolean updateSubscribe(String oaId, String openId, boolean subscribe);

    /**
     * 更新sellerId和subscribe
     *
     * @param oaId
     * @param openId
     * @param subscribe
     * @return
     */
    boolean updateSellerIdAndSubscribe(String oaId, String openId, Long sellerId, boolean subscribe);

    /**
     * 根据条件查询
     * @param sellerId
     * @param oaId
     * @param subscribe
     * @return
     */
    SellerVipDto findByCondition(Long sellerId, String oaId, boolean subscribe);
}
