package cn.com.duiba.kjy.api.enums;

import cn.com.duiba.kjy.api.constant.UserExtTypeEnum;

import java.util.Objects;

/**
 * Created by dugq on 2019-06-01.
 */
public enum OATypeEnum{
    CONTENT_MAIN_OA(1,"内容主体公众号"){
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.OA;
        }
    },
    VIP_OA(2,"付费用户的VIP专属公众号"){
        @Override
        public UserExtTypeEnum change2ExtTypeEnum() {
            return UserExtTypeEnum.VIP;
        }
    }
    ;
    private Integer type;
    private String desc;

    OATypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public Integer getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }

    public static OATypeEnum typeOf(Integer type) {
        for (OATypeEnum e :values())
            if (Objects.equals(type, e.getType())) {
                return e;
            }
        throw new UnsupportedOperationException("不支持的oa类型");
    }

    public abstract UserExtTypeEnum change2ExtTypeEnum();
}
