package cn.com.duiba.kjy.api.remoteservice;

/*
 * Created with IntelliJ IDEA.
 * User: ChuanJiang
 * Date: 2019/6/28.
 * Time: 11:54.
 */

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.BlackListDto;

import java.util.List;

/**
 * 黑名单相关接口
 */
@AdvancedFeignClient
public interface RemoteBlackListService {
    /**
     * 插入活动黑名单记录 ps：此阶段暂时只支持活动和公司列表
     * @param activityId 活动Id
     * @param companyIds 公司Id列表
     * @return  成功条数
     */
    Integer addOrUpdateBlackList(Long activityId, List<Long> companyIds);

    /**
     * 根据活动Id查询所有相关黑名单列表
     * @param activityId 活动Id
     * @return List<BlackListDto> {@link BlackListDto} 黑名单列表
     */
    List<BlackListDto> getBlackListByActivityId(Long activityId);

    /**
     * 根据活动id和公司id返回黑名单列表
     * @param activityId 活动id
     * @param companyId  公司id
     * @return 黑名单列表
     */
    List<BlackListDto> getBlackListByActivityIdAndCompanyId(Long activityId,Long companyId);

}
