package cn.com.duiba.kjy.api.remoteservice.guide;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.constant.KjyCenterException;
import cn.com.duiba.kjy.api.dto.usingStrategy.StrategySuccessCaseDto;
import cn.com.duiba.kjy.api.params.guide.StrategySuccessCaseMoveParam;
import cn.com.duiba.kjy.api.params.guide.StrategySuccessCaseParam;

import java.util.List;

/**
 * 使用攻略成功案例
 * @author 吴文哲
 * @date 2020-01-11 14:24
 **/
@AdvancedFeignClient
public interface RemoteStrategySuccessCaseService {

    /**
     * 获取成功案例列表
     * @param param
     * @return
     */
    List<StrategySuccessCaseDto> getCaseList(StrategySuccessCaseParam param);

    /**
     * 根据条件统计
     * @param param
     * @return
     */
    Integer getCaseCount(StrategySuccessCaseParam param);


    /**
     * 新增/修改 成功案例
     * @param dto
     * @return
     */
    Integer addOrUpdateCase(StrategySuccessCaseDto dto) throws KjyCenterException;


    /**
     * 移动成功案例
     * @param moveParam
     * @return
     */
    Boolean moveCase(StrategySuccessCaseMoveParam moveParam) throws KjyCenterException;

    /**
     * 获取成功案例详情
     * @param caseId
     * @return
     */
    StrategySuccessCaseDto getSuccessCaseDetail(Long caseId);

}
