package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.SellerDto;
import cn.com.duiba.kjy.api.dto.UserDto;

/**
 * 代理人-用户服务
 * @author liuchao1
 * @version 1.0
 * @date 2020-07-25 15:28
 */
@AdvancedFeignClient
public interface RemoteSellerUserService {

    /**
     * 保存用户信息和代理人信息
     * @param userDto 用户信息
     * @param sellerDto 代理人信息
     * @param cardImg 名片图片地址
     * @return 代理人id
     */
    Long save(UserDto userDto, SellerDto sellerDto, String cardImg);

    /**
     * 更新用户、代理人信息，用户id必传
     * @param userDto 用户信息
     * @param sellerDto 代理人信息
     * @param cardImg 名片图片地址
     * @return 代理人id
     */
    Long updateInfo(UserDto userDto, SellerDto sellerDto, String cardImg);

    /**
     * 根据代理人id获取名片图片地址
     * @param sellerId 代理人id
     * @return 代理人图片地址
     */
    String getCardImg(Long sellerId);
}
