package cn.com.duiba.kjy.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.dto.vipTransfer.VipTransferVerifyRecordDto;
import cn.com.duiba.kjy.api.params.seller.VipTransferVerifyRecordQueryParam;

import java.util.List;

/**
 * @author liuchao1
 * @date 2020/5/8 14:19
 */
@AdvancedFeignClient
public interface RemoteVipTransferVerifyRecordService {

    /**
     * 保存会员迁移审核记录
     * @param dto 会员迁移审核记录
     * @return 主键id
     */
    Long save(VipTransferVerifyRecordDto dto);

    /**
     * 根据主键id修改会员迁移审核记录
     * @param dto 会员迁移审核记录
     * @return 修改结果
     */
    boolean update(VipTransferVerifyRecordDto dto);

    /**
     * 根据主键id查询
     * @param id 主键id
     * @return 会员迁移审核记录
     */
    VipTransferVerifyRecordDto findById(Long id);

    /**
     * 分页查询
     * @param param 分页查询参数
     * @return
     */
    List<VipTransferVerifyRecordDto> getListByParam(VipTransferVerifyRecordQueryParam param);

    /**
     * 统计分页总数
     * @param param 查询参数
     * @return
     */
    Integer countByParam(VipTransferVerifyRecordQueryParam param);

}
