package cn.com.duiba.kjy.api.params.preInstall;

import lombok.Data;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 功能描述：财务审核打款列表筛选
 *
 * @author xiaotian
 * @Date: 2020/4/13 14:12
 * @Description:
 */
@Data
public class SerialPayCheckParam implements Serializable {

    private static final long serialVersionUID = 6532781593830046845L;
    /**
     * 主键ID
     */
    @NotNull(message = "id不能为空")
    private Long id;

    /**
     * 0:待审核 1：审核通过 2：审核失败
     */
    @NotNull(message = "状态不能为空")
    private Integer status;

    /**
     * 评论
     */
    private String remark;

    /**
     * 审批人ID
     */
    private String checkerId;

    /**
     * 审批人角色
     */
    private Integer cherkerType;
}
